/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.renderer.ModelBuffer;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.constants.EnumRewardType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerCompassHUDData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;
import org.lwjgl.opengl.GL11;

public class GuiLog
extends GuiNPCInterface
implements GuiYesNoCallback,
IGuiData,
ISliderListener,
ITextfieldListener {
    protected static final Map<Integer, ResourceLocation> ql = new TreeMap<Integer, ResourceLocation>();
    protected static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    protected static final ResourceLocation killIcon = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    public static float scaleW;
    public static float scaleH;
    public static QuestInfo activeQuest;
    protected int hoverButton;
    protected int hoverQuestId;
    protected int catRow;
    protected int catSelect;
    protected int page;
    protected int step;
    protected int tick;
    protected int milliTick;
    protected int temp;
    protected int guiLLeft;
    protected int guiLRight;
    protected int guiLTop;
    protected int guiTopLog;
    protected int guiCenter;
    public int type;
    protected boolean toPrePage = true;
    protected final Random rnd = new Random();
    protected ScaledResolution sw;
    protected final Map<String, Map<Integer, QuestData>> quests = new TreeMap<String, Map<Integer, QuestData>>();
    protected final Map<String, Color> categories = new TreeMap<String, Color>();
    protected final List<Faction> playerFactions = new ArrayList<Faction>();
    protected final PlayerCompassHUDData compassData;
    protected PlayerData playerData;

    public static boolean preDrawEntity(String modelName) {
        boolean canUpdate = true;
        switch (modelName) {
            case "customnpcs:npcslime": 
            case "minecraft:shulker": {
                GlStateManager.func_179109_b((float)-2.0f, (float)(-15.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:magma_cube": 
            case "minecraft:silverfish": 
            case "minecraft:slime": {
                GlStateManager.func_179109_b((float)-2.0f, (float)(-21.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:zombie": {
                GlStateManager.func_179109_b((float)3.0f, (float)(9.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:vex": {
                GlStateManager.func_179109_b((float)-3.0f, (float)(-15.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:endermite": {
                GlStateManager.func_179109_b((float)-1.0f, (float)(-25.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:enderman": {
                GlStateManager.func_179109_b((float)0.0f, (float)(30.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:cave_spider": {
                GlStateManager.func_179109_b((float)-2.0f, (float)(-18.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:chicken": 
            case "minecraft:wolf": 
            case "minecraft:ocelot": 
            case "minecraft:spider": {
                GlStateManager.func_179109_b((float)0.0f, (float)(-15.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:squid": {
                GlStateManager.func_179109_b((float)0.0f, (float)(-5.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:guardian": {
                GlStateManager.func_179109_b((float)4.0f, (float)(-18.5f * scaleH), (float)0.0f);
                canUpdate = false;
                break;
            }
            case "minecraft:parrot": 
            case "minecraft:rabbit": 
            case "minecraft:bat": {
                GlStateManager.func_179109_b((float)0.0f, (float)(-19.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:horse": 
            case "minecraft:illusion_illager": 
            case "minecraft:villager": 
            case "minecraft:snowman": 
            case "minecraft:vindication_illager": 
            case "minecraft:zombie_horse": 
            case "minecraft:zombie_villager": 
            case "minecraft:stray": 
            case "minecraft:skeleton": 
            case "minecraft:witch": 
            case "minecraft:skeleton_horse": 
            case "minecraft:mule": 
            case "minecraft:evocation_illager": 
            case "minecraft:zombie_pigman": {
                GlStateManager.func_179109_b((float)0.0f, (float)(5.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:ender_dragon": {
                GlStateManager.func_179109_b((float)35.0f, (float)(-32.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                break;
            }
            case "minecraft:elder_guardian": {
                GlStateManager.func_179109_b((float)1.5f, (float)(-15.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                canUpdate = false;
                break;
            }
            case "minecraft:giant": {
                GlStateManager.func_179109_b((float)0.0f, (float)(15.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.1875f, (float)0.1875f, (float)0.1875f);
                canUpdate = false;
                break;
            }
            case "customnpcs:npcdragon": {
                GlStateManager.func_179109_b((float)22.0f, (float)(-16.0f * scaleH), (float)0.0f);
                canUpdate = false;
                break;
            }
            case "customnpcs:npcpony": {
                GlStateManager.func_179109_b((float)-5.0f, (float)(2.0f * scaleH), (float)0.0f);
                break;
            }
            case "customnpcs:npccrystal": {
                GlStateManager.func_179109_b((float)0.0f, (float)(3.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:wither_skeleton": 
            case "minecraft:villager_golem": 
            case "minecraft:customnpcs.npcgolem": {
                GlStateManager.func_179109_b((float)0.0f, (float)(18.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:polar_bear": {
                GlStateManager.func_179109_b((float)-1.0f, (float)(-12.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                break;
            }
            case "minecraft:husk": 
            case "minecraft:llama": {
                GlStateManager.func_179109_b((float)0.0f, (float)(12.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:pig": {
                GlStateManager.func_179109_b((float)0.0f, (float)(-12.0f * scaleH), (float)0.0f);
                break;
            }
            case "minecraft:wither": {
                GlStateManager.func_179109_b((float)-3.0f, (float)(3.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                break;
            }
            case "minecraft:ghast": {
                GlStateManager.func_179109_b((float)-2.0f, (float)(-21.0f * scaleH), (float)0.0f);
                GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
                break;
            }
            case "minecraft:customnpcs.customnpcalex": {
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)0.0f, (float)(-8.0f * scaleH), (float)0.0f);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)210.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        return canUpdate;
    }

    public GuiLog(int t) {
        this.type = t;
        this.temp = 0;
        this.tick = 15;
        this.milliTick = 15;
        this.step = 0;
        this.closeOnEsc = true;
        this.xSize = 0;
        this.ySize = 0;
        this.field_146294_l = 0;
        this.field_146295_m = 0;
        this.hoverButton = -1;
        this.hoverQuestId = 0;
        this.catRow = 0;
        this.catSelect = 0;
        this.page = 0;
        this.sw = new ScaledResolution(this.field_146297_k);
        this.compassData = new PlayerCompassHUDData();
        this.compassData.load(CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player).hud.compassData.getNbt());
        activeQuest = null;
        if (t == 1) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.FactionsGet, new Object[0]);
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (this.type != 2) {
            return;
        }
        switch (button.getID()) {
            case 0: {
                this.compassData.showQuestName = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 1: {
                this.compassData.showTaskProgress = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 2: {
                CustomNpcs.ShowQuestCompass = ((GuiNpcCheckBox)button).isSelected();
            }
        }
    }

    public void buttonPress(int id) {
        if (this.type == 0 && id > 6 && id < 15) {
            int catList = this.catRow * 8 + id - 7;
            if (this.catSelect == catList && this.page != 0) {
                this.step = 11;
                this.tick = 10;
                this.milliTick = 10;
                this.page = 0;
            }
            if (this.catSelect != catList || activeQuest != null) {
                this.step = this.catSelect > catList || activeQuest != null ? 11 : 10;
                this.tick = 11;
                this.milliTick = 10;
                this.catSelect = catList;
                this.page = 0;
                activeQuest = null;
            }
            return;
        }
        switch (id) {
            case 0: {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.tick = 15;
                this.milliTick = 15;
                this.step = this.type + 7;
                this.type = -1;
                break;
            }
            case 1: {
                if (this.type == 1) {
                    return;
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.tick = 15;
                this.milliTick = 15;
                this.toPrePage = false;
                this.step = this.type + 7;
                this.page = 0;
                this.type = 1;
                NoppesUtilPlayer.sendData(EnumPlayerPacket.FactionsGet, new Object[0]);
                this.func_73866_w_();
                break;
            }
            case 2: {
                if (this.type == 0) {
                    return;
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.tick = 15;
                this.milliTick = 15;
                this.toPrePage = this.type == 1;
                this.step = this.type + 7;
                this.catRow = 0;
                this.catSelect = 0;
                this.page = 0;
                activeQuest = null;
                this.type = 0;
                this.func_73866_w_();
                break;
            }
            case 3: {
                if (this.type == 2 || !CustomNpcs.ShowQuestCompass) {
                    return;
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.tick = 15;
                this.milliTick = 15;
                this.toPrePage = true;
                this.step = this.type + 7;
                this.page = 0;
                this.type = 2;
                this.func_73866_w_();
                break;
            }
            case 4: {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                ++this.page;
                this.step = 10;
                this.tick = 10;
                this.milliTick = 10;
                break;
            }
            case 5: {
                --this.page;
                this.step = 11;
                this.tick = 10;
                this.milliTick = 10;
                break;
            }
            case 6: {
                if (this.hoverQuestId < 1) {
                    return;
                }
                String catName = "";
                int i = 0;
                for (String key : this.categories.keySet()) {
                    if (i == this.catSelect) {
                        catName = key;
                        break;
                    }
                    ++i;
                }
                if (catName.isEmpty() || !this.quests.containsKey(catName) || !this.quests.get(catName).containsKey(this.hoverQuestId)) {
                    return;
                }
                activeQuest = new QuestInfo(this.quests.get(catName).get(this.hoverQuestId), (World)this.field_146297_k.field_71441_e);
                this.step = 10;
                this.tick = 10;
                this.milliTick = 10;
                break;
            }
            case 16: {
                if (this.type != 0) {
                    return;
                }
                MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.sheet", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.8f + 0.4f * this.rnd.nextFloat());
                --this.catRow;
                break;
            }
            case 17: {
                if (this.type != 0) {
                    return;
                }
                MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.sheet", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.8f + 0.4f * this.rnd.nextFloat());
                ++this.catRow;
                break;
            }
            case 30: {
                if (this.hoverQuestId <= 0) {
                    return;
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                EventHooks.onEvent((IScriptHandler)ScriptController.Instance.clientScripts, EnumScriptType.QUEST_LOG_BUTTON, (Event)new QuestEvent.QuestExtraButtonEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.player), QuestController.instance.get(this.hoverQuestId)));
                NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestExtraButton, this.hoverQuestId);
                break;
            }
            case 31: {
                if (this.hoverQuestId <= 0) {
                    return;
                }
                ClientProxy.playerData.hud.questID = ClientProxy.playerData.hud.questID == this.hoverQuestId ? -1 : this.hoverQuestId;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                break;
            }
            case 32: {
                if (this.hoverQuestId <= 0) {
                    return;
                }
                block15: for (Map<Integer, QuestData> map : this.quests.values()) {
                    for (QuestData qd : map.values()) {
                        if (qd.quest.id != this.hoverQuestId) continue;
                        GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("drop.quest", new Object[]{new TextComponentTranslation(qd.quest.getTitle(), new Object[0]).func_150254_d()}).func_150254_d(), new TextComponentTranslation("quest.cancel.info", new Object[0]).func_150254_d(), this.hoverQuestId);
                        this.displayGuiScreen((GuiScreen)guiyesno);
                        continue block15;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void close() {
        PlayerCompassHUDData compassD = CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player).hud.compassData;
        NBTTagCompound compound = this.compassData.getNbt();
        compassD.load(compound);
        NoppesUtilPlayer.sendData(EnumPlayerPacket.SaveCompassData, compound);
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestRemoveActive, id);
        PlayerQuestData data = CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player).questData;
        if (data != null) {
            data.activeQuests.remove(id);
            this.func_73866_w_();
        }
    }

    protected void drawBox(int mouseX, int mouseY) {
        this.hoverButton = -1;
        this.hoverQuestId = 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 10), (float)this.guiTop, (float)0.0f);
        boolean offset = false;
        for (int i = 0; i < (CustomNpcs.ShowQuestCompass ? 4 : 3); ++i) {
            ItemStack stack;
            boolean hover;
            switch (i) {
                case 1: {
                    if (offset) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    offset = this.type == 1;
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)(offset ? 1.0f : 0.0f));
                    hover = this.isMouseHover(mouseX, mouseY, this.guiLeft + 43, this.guiTop, 28, 30);
                    break;
                }
                case 2: {
                    if (offset) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    offset = this.type == 0;
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)(offset ? 1.0f : 0.0f));
                    hover = this.isMouseHover(mouseX, mouseY, this.guiLeft + 76, this.guiTop, 28, 30);
                    break;
                }
                case 3: {
                    if (offset) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    offset = this.type == 2;
                    GlStateManager.func_179109_b((float)(-114.0f + 256.0f * scaleW), (float)0.0f, (float)(offset ? 1.0f : 0.0f));
                    hover = this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLeft - 38.0f + 256.0f * scaleW), this.guiTop, 28, 30);
                    break;
                }
                default: {
                    hover = this.isMouseHover(mouseX, mouseY, this.guiLeft + 10, this.guiTop, 28, 30);
                }
            }
            if (hover) {
                this.hoverButton = i;
            }
            this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
            this.func_73729_b(0, 0, 0, hover || offset ? 30 : 60, 28, 30);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)6.0f, (float)8.0f, (float)0.0f);
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179091_B();
            switch (i) {
                case 1: {
                    stack = new ItemStack(Items.field_179564_cE, 1, 1);
                    break;
                }
                case 2: {
                    stack = new ItemStack(Items.field_151122_aG);
                    break;
                }
                case 3: {
                    stack = new ItemStack(Items.field_151111_aL);
                    break;
                }
                default: {
                    stack = new ItemStack(Blocks.field_150462_ai);
                }
            }
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(stack, 0, 0);
            this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, stack, 6, 8, null);
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTopLog, (float)0.0f);
        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
        this.func_73729_b(0, 0, 0, 0, 256, 175);
        this.field_146297_k.func_110434_K().func_110577_a(ql.get(1));
        this.func_73729_b(0, 0, 0, 0, 256, 175);
        GlStateManager.func_179121_F();
        if (this.step == -1 && (this.type == 0 || this.type == 1)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.guiLLeft + 2.0f * scaleH), (float)((float)this.guiLTop + 152.5f * scaleH), (float)0.0f);
            this.field_146289_q.func_78276_b("" + (this.page * 2 + 1), 0, 0, CustomNpcs.NotEnableColor.getRGB());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            String p = "" + (this.page * 2 + 2);
            GlStateManager.func_179109_b((float)((float)(this.guiLLeft - this.field_146289_q.func_78256_a(p)) + 205.0f * scaleW), (float)((float)this.guiLTop + 153.0f * scaleH), (float)0.0f);
            this.field_146289_q.func_78276_b(p, 0, 0, CustomNpcs.NotEnableColor.getRGB());
            GlStateManager.func_179121_F();
        }
        if (this.step >= 0 && this.step < 10) {
            return;
        }
        if (this.type == 0) {
            this.drawQuestLog(mouseX, mouseY);
        } else if (this.type == 1) {
            this.drawFaction(mouseX, mouseY);
        } else if (this.type == 2) {
            this.drawCompass();
        }
    }

    protected void drawCompass() {
        int w;
        String text;
        if (!CustomNpcs.ShowQuestCompass || this.step != -1) {
            return;
        }
        this.field_146289_q.func_78276_b(new TextComponentTranslation("quest.screen.pos", new Object[0]).func_150254_d(), (int)((float)this.guiLLeft - 3.0f * scaleW), this.guiLTop, CustomNpcs.QuestLogColor.getRGB());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.guiLLeft - 3.0f * scaleW), (float)(this.guiLTop + 10), (float)0.0f);
        GlStateManager.func_179152_a((float)(0.5f * scaleW), (float)(0.5f * scaleH), (float)0.5f);
        Gui.func_73734_a((int)-1, (int)-1, (int)207, (int)139, (int)-8355712);
        Gui.func_73734_a((int)0, (int)0, (int)206, (int)138, (int)-986896);
        Gui.func_73734_a((int)58, (int)113, (int)149, (int)139, (int)-8355712);
        Gui.func_73734_a((int)59, (int)114, (int)148, (int)138, (int)-6250336);
        GlStateManager.func_179137_b((double)(this.compassData.screenPos[0] * 206.0), (double)(this.compassData.screenPos[1] * 138.0), (double)0.0);
        Gui.func_73734_a((int)-3, (int)-1, (int)4, (int)3, (int)-16776961);
        Gui.func_73734_a((int)-3, (int)3, (int)4, (int)5, (int)-65281);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.guiLLeft - 3.0f * scaleW), (float)((float)this.guiLTop + 84.0f * scaleH), (float)0.0f);
        this.func_73731_b(this.field_146289_q, " ", 0, 0, -1);
        this.field_146289_q.func_78276_b("U:", 0, 0, CustomNpcs.QuestLogColor.getRGB());
        this.field_146289_q.func_78276_b("V:", (int)(54.0f * scaleW), 0, CustomNpcs.QuestLogColor.getRGB());
        this.field_146289_q.func_78276_b("S:", 0, (int)(18.0f * scaleH), CustomNpcs.QuestLogColor.getRGB());
        this.field_146289_q.func_78276_b("T:", 0, (int)(34.0f * scaleH), CustomNpcs.QuestLogColor.getRGB());
        this.field_146289_q.func_78276_b("R:", 0, (int)(50.0f * scaleH), CustomNpcs.QuestLogColor.getRGB());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLRight + (int)(3.0f * scaleW)), (float)(this.guiLTop + (int)(91.0f * scaleH)), (float)0.0f);
        int i = 0;
        if (this.compassData.showQuestName) {
            text = new TextComponentTranslation("quest.setts.q.name", new Object[0]).func_150254_d();
            w = (int)(49.0f * scaleW) - this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, w, 0, CustomNpcs.QuestLogColor.getRGB());
            i = 12;
        }
        if (this.compassData.showTaskProgress) {
            text = new TextComponentTranslation("quest.setts.q.tasks", new Object[0]).func_150254_d();
            w = (int)(49.0f * scaleW) - this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, w, i, CustomNpcs.QuestLogColor.getRGB());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLRight + (int)(52.0f * scaleW)), (float)(this.guiLTop + (int)(57.0f * scaleH)), (float)50.0f);
        float scale = -30.0f * this.compassData.scale;
        float incline = -45.0f + this.compassData.incline;
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179109_b((float)0.0f, (float)((-32.85714f * this.compassData.scale + 32.42857f) * scaleH), (float)0.0f);
        GlStateManager.func_179152_a((float)(scale * scaleW), (float)(scale * scaleH), (float)scale);
        GlStateManager.func_179114_b((float)incline, (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.compassData.rot != 0.0f) {
            GlStateManager.func_179114_b((float)this.compassData.rot, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179148_o((int)ModelBuffer.getDisplayList(ClientGuiEventHandler.RESOURCE_COMPASS, new ArrayList<String>(Arrays.asList("body", "dial", "arrow_1", "arrow_20", "fase")), null));
        GlStateManager.func_179114_b((float)((float)(System.currentTimeMillis() % 3500L) / 9.722222f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)ModelBuffer.getDisplayList(ClientGuiEventHandler.RESOURCE_COMPASS, Collections.singletonList("arrow_0"), null));
        GlStateManager.func_179121_F();
    }

    protected void drawFaction(int mouseX, int mouseY) {
        if (this.step != -1) {
            return;
        }
        if (this.playerFactions.isEmpty()) {
            String noFaction = new TextComponentTranslation("faction.nostanding", new Object[0]).func_150254_d();
            this.field_146289_q.func_78279_b(noFaction, this.guiLeft + 24, this.guiTop + 36, 98, CustomNpcs.QuestLogColor.getRGB());
            return;
        }
        if (this.playerFactions.size() > 16) {
            if (this.page > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLLeft - 5.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLLeft - 5.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 5;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 5 ? 26 : 3, 207, 18, 10);
                GlStateManager.func_179121_F();
            }
            if (Math.floor((double)this.playerFactions.size() / 16.0) > (double)this.page) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLeft + 230.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLeft + 230.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 4;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 4 ? 26 : 3, 194, 18, 10);
                GlStateManager.func_179121_F();
            }
        }
        int i = 0;
        int p = 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLLeft, (float)this.guiLTop, (float)0.0f);
        for (Faction f : this.playerFactions) {
            float w;
            Color h;
            if (f.hideFaction && !this.player.field_71075_bZ.field_75098_d) continue;
            if (p < this.page * 10) {
                ++p;
                continue;
            }
            if (i == 8) {
                GlStateManager.func_179109_b((float)(105.0f * scaleW), (float)(-133.0f * scaleH), (float)0.0f);
            } else if (i % 8 != 0) {
                GlStateManager.func_179109_b((float)0.0f, (float)(19.0f * scaleH), (float)0.0f);
            }
            if (f.hideFaction) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                this.func_73733_a(1, 1, 90, 12, 0x20FF0000, -2130771968);
                GlStateManager.func_179121_F();
            }
            this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
            Color c = new Color(f.color);
            GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
            this.func_73729_b(0, 0, 158, 74, 98, 16);
            GlStateManager.func_179121_F();
            int points = this.playerData.factionData.getFactionPoints((EntityPlayer)this.player, f.id);
            int nextPoint = 0;
            int t = 0;
            if (f.isNeutralToPlayer((EntityPlayer)this.player)) {
                t = 1;
                h = new Color(15916288);
                w = (float)(f.friendlyPoints - points) / (float)(f.friendlyPoints - f.neutralPoints);
                nextPoint = f.friendlyPoints;
            } else if (f.isFriendlyToPlayer((EntityPlayer)this.player)) {
                t = 2;
                h = new Color(56576);
                w = (float)(f.friendlyPoints * 2 - points) / (float)f.friendlyPoints;
            } else {
                h = new Color(0xDD0000);
                w = (float)(f.neutralPoints - points) / (float)f.neutralPoints;
                nextPoint = f.neutralPoints;
            }
            if (w < 0.0f) {
                w = 0.0f;
            } else if (w > 1.0f) {
                w = 1.0f;
            }
            int em = (int)(89.0f * w);
            int ew = 89 - em;
            if (em > 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                this.func_73729_b(90 - em, 12, 256 - em, 71, em, 3);
                GlStateManager.func_179121_F();
            }
            if (ew > 0) {
                GlStateManager.func_179131_c((float)((float)h.getRed() / 255.0f), (float)((float)h.getGreen() / 255.0f), (float)((float)h.getBlue() / 255.0f), (float)0.65f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                this.func_73729_b(1, 12, 167, 71, ew, 3);
                GlStateManager.func_179121_F();
            }
            StringBuilder name = new StringBuilder();
            String qName = f.getName();
            if ((float)this.field_146289_q.func_78256_a(qName) < 87.0f * scaleW) {
                name = new StringBuilder(qName);
            } else {
                for (int j = 0; j < qName.length(); ++j) {
                    if ((float)this.field_146289_q.func_78256_a(name.toString() + qName.charAt(j) + "...") >= 87.0f * scaleW) break;
                    name.append(qName.charAt(j));
                }
                name.append("...");
            }
            this.field_146289_q.func_175065_a(name.toString(), 3.0f * scaleW, 2.0f * scaleH, CustomNpcs.QuestLogColor.getRGB(), false);
            if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLLeft + (i > 4 ? 105.0f : 0.0f) * scaleW), (int)((float)this.guiLTop + (float)(i % 8) * 19.0f * scaleH), (int)(98.0f * scaleW), (int)(16.0f * scaleH))) {
                ArrayList<String> hover = new ArrayList<String>();
                if (f.hideFaction) {
                    hover.add(new TextComponentTranslation("faction.hover.hidden", new Object[0]).func_150254_d());
                }
                if (this.player.field_71075_bZ.field_75098_d) {
                    hover.add("\u00a77ID:" + f.id + "; " + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + f.getName());
                } else {
                    hover.add("\u00a77" + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + f.getName());
                }
                hover.add("\u00a77" + new TextComponentTranslation("gui.attitude", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + (t == 0 ? "4" + new TextComponentTranslation("faction.unfriendly", new Object[0]).func_150254_d() : (t == 2 ? "2" + new TextComponentTranslation("faction.friendly", new Object[0]).func_150254_d() : "6" + new TextComponentTranslation("faction.neutral", new Object[0]).func_150254_d())));
                hover.add("\u00a77" + new TextComponentTranslation("faction.points", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + points + (nextPoint != 0 ? "/" + nextPoint : ""));
                if (!f.description.isEmpty()) {
                    hover.add("\u00a77" + new TextComponentTranslation("gui.description", new Object[0]).func_150254_d());
                    hover.add(new TextComponentTranslation(f.description, new Object[0]).func_150254_d());
                }
                this.setHoverText(hover);
            }
            this.field_146297_k.func_110434_K().func_110577_a(f.flag);
            this.field_146297_k.func_110434_K().func_110581_b(f.flag);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(90.0f * scaleW), (float)scaleH, (float)0.0f);
            GlStateManager.func_179152_a((float)0.175f, (float)0.11f, (float)1.0f);
            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
            GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
            this.func_73729_b(0, 0, 4, 4, 40, 128);
            GlStateManager.func_179121_F();
            ++p;
            if (++i != 16) continue;
            break;
        }
        GlStateManager.func_179121_F();
    }

    protected void drawNpc(EntityNPCInterface npc) {
        if (npc == null) {
            return;
        }
        GlStateManager.func_179109_b((float)((float)this.guiLLeft + 49.0f * scaleW), (float)((float)this.guiLTop + 67.0f * scaleH), (float)0.0f);
        String modelName = "";
        if (npc.display.getModel() != null) {
            modelName = npc.display.getModel();
        }
        boolean canUpdate = GuiLog.preDrawEntity(modelName);
        GlStateManager.func_179147_l();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        GlStateManager.func_179152_a((float)25.0f, (float)25.0f, (float)25.0f);
        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
        npc.field_70173_aa = 100;
        if (canUpdate) {
            npc.func_70071_h_();
        }
        this.field_146297_k.func_175598_ae().func_188391_a((Entity)npc, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void drawQuestLog(int mouseX, int mouseY) {
        if (this.categories.isEmpty()) {
            String noFaction = new TextComponentTranslation("quest.noquests", new Object[0]).func_150254_d();
            this.field_146289_q.func_78279_b(noFaction, this.guiLLeft, this.guiLTop, (int)(98.0f * scaleW), CustomNpcs.QuestLogColor.getRGB());
            return;
        }
        List<String> hover = new ArrayList<String>();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)((float)this.guiTopLog + 23.5f * scaleH), (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
        if (this.catRow > 0) {
            if (this.isMouseHover(mouseX, mouseY, this.guiLeft - (int)(17.0f * scaleW), (int)((float)this.guiTopLog + 7.5f * scaleH), (int)(18.0f * scaleW), (int)(16.0f * scaleH))) {
                this.hoverButton = 16;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(-17, -16, 111, this.hoverButton == 16 ? 30 : 46, 18, 16);
            GlStateManager.func_179121_F();
        }
        if (this.categories.size() - (this.catRow + 1) * 8 > 0) {
            if (this.isMouseHover(mouseX, mouseY, this.guiLeft - (int)(17.0f * scaleW), (int)((float)this.guiTopLog + 151.5f * scaleH), (int)(18.0f * scaleW), (int)(16.0f * scaleH))) {
                this.hoverButton = 17;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(-17, 128, 129, this.hoverButton == 17 ? 30 : 46, 18, 16);
            GlStateManager.func_179121_F();
        }
        int i = 0;
        int p = 0;
        int st = this.catRow * 8;
        String selectCat = "";
        for (String fullCatName : this.categories.keySet()) {
            String catName = fullCatName;
            if (this.field_146289_q.func_78256_a(catName) > 80) {
                StringBuilder tempCatName = new StringBuilder();
                for (int g = 0; g < catName.length(); ++g) {
                    char c = catName.charAt(g);
                    if (this.field_146289_q.func_78256_a(tempCatName.toString() + c + "...") > 86) break;
                    tempCatName.append(c);
                }
                catName = tempCatName + "...";
            }
            if (p < st) {
                if (this.catSelect == p && this.step < 0) {
                    selectCat = catName;
                }
                ++p;
                continue;
            }
            int catW = this.field_146289_q.func_78256_a(catName) + 10 + i;
            this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
            if (this.isMouseHover(mouseX, mouseY, this.guiLeft + (int)((float)(5 - catW) * scaleW), (int)((float)this.guiTopLog + (23.5f + (float)i * 16.0f) * scaleH), (int)((float)catW * scaleH), (int)(16.0f * scaleH))) {
                this.hoverButton = 7 + i;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
            this.func_73729_b(4 - (int)((float)catW / scaleW) + i, i * 16, 0, 90 + (this.catSelect == p || this.hoverButton == 7 + i ? 0 : 16), (int)((float)catW / scaleW), 16);
            GlStateManager.func_179121_F();
            if (this.catSelect == p && this.step < 0) {
                selectCat = catName;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                this.func_73729_b(3 + i, i * 16, 234 + i, 90, 22 - i, 16);
                GlStateManager.func_179121_F();
            }
            StringBuilder name = new StringBuilder();
            for (int j = 0; j < catName.length() && this.field_146289_q.func_78256_a(name.toString() + catName.charAt(j)) <= catW - 5; ++j) {
                name.append(catName.charAt(j));
            }
            this.field_146289_q.func_175065_a(name.toString(), (float)(4 - catW + 10 + i), (16.0f * scaleH - 10.0f) / 2.0f + (float)i * 16.0f * scaleH, CustomNpcs.QuestLogColor.getRGB(), false);
            ++p;
            if (++i < 8) continue;
            break;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        if (this.step != -1) {
            return;
        }
        if (activeQuest != null) {
            int first = 0;
            if (GuiLog.activeQuest.qData.quest.completion == EnumQuestCompletion.Npc && GuiLog.activeQuest.npc != null) {
                if (this.page == 0) {
                    GlStateManager.func_179094_E();
                    GL11.glEnable((int)3089);
                    int c = this.sw.func_78326_a() < this.field_146297_k.field_71443_c ? (int)Math.round((double)this.field_146297_k.field_71443_c / (double)this.sw.func_78326_a()) : 1;
                    GL11.glScissor((int)((int)((float)this.guiLLeft + 22.0f * scaleW) * c), (int)((int)((float)this.guiLTop + (12.0f * scaleH + 81.0f) * scaleH) * c), (int)((int)(54.0f * scaleW) * c), (int)((int)(38.0f * scaleH) * c));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.drawNpc(GuiLog.activeQuest.npc);
                    GL11.glDisable((int)3089);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiLLeft + 16.5f * scaleW), (float)((float)this.guiLTop - 4.0f * scaleH), (float)500.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)3.0f, (float)3.0f, (float)3.0f, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    this.func_73729_b(0, 0, 193, 0, 63, 52);
                    GlStateManager.func_179121_F();
                }
                first = (int)(44.0f * scaleH);
            }
            ItemStack[] stacks = GuiLog.activeQuest.stacks.toArray(new ItemStack[0]);
            int j = 0;
            int k = 0;
            for (int l = 0; l < 2; ++l) {
                List<String> list = activeQuest.getText(first, (EntityPlayer)this.player, this.field_146289_q).get(this.page + l);
                if (list == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)this.guiLLeft, (double)this.guiLTop, (double)501.0);
                int h = 0;
                for (String line : list) {
                    int pos;
                    if (line.contains(" \uffff ") || line.contains("\uffff ")) {
                        if (j < stacks.length) {
                            float y;
                            pos = this.field_146289_q.func_78256_a(line.substring(0, line.indexOf("\uffff") - 1));
                            ItemStack stack = stacks[j];
                            float x = (float)pos + (l == 1 ? 105.0f : 0.0f) * scaleW;
                            if (this.isMouseHover(mouseX, mouseY, this.guiLLeft + (int)x, this.guiLTop + (int)(y = (this.page == 0 && l == 0 ? (float)first : 0.0f) + (float)h * 12.0f), 10, 10)) {
                                hover = stack.func_82840_a((EntityPlayer)this.player, (ITooltipFlag)(this.player.field_71075_bZ.field_75098_d ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                                this.setHoverText(hover);
                            }
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)(x - 4.0f), (float)(y - 5.5f), (float)0.0f);
                            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
                            GlStateManager.func_179109_b((float)6.0f, (float)8.0f, (float)0.0f);
                            this.field_73735_i = 100.0f;
                            this.field_146296_j.field_77023_b = 100.0f;
                            GlStateManager.func_179145_e();
                            GlStateManager.func_179091_B();
                            RenderHelper.func_74520_c();
                            this.field_146296_j.func_180450_b(stack, 0, 0);
                            RenderHelper.func_74518_a();
                            GlStateManager.func_179140_f();
                            this.field_146296_j.field_77023_b = 0.0f;
                            this.field_73735_i = 0.0f;
                            GlStateManager.func_179121_F();
                            ++j;
                        }
                        line = line.replace("\uffff", " " + (!line.contains(" \uffff ") ? " " : ""));
                    }
                    if (line.indexOf(65534) != -1) {
                        if (GuiLog.activeQuest.entitys.containsKey(k)) {
                            float y;
                            pos = this.field_146289_q.func_78256_a(line.substring(0, line.indexOf("\ufffe") - 1));
                            float x = (float)pos + (l == 1 ? 105.0f : 0.0f) * scaleW;
                            if (this.isMouseHover(mouseX, mouseY, this.guiLLeft + (int)x, this.guiLTop + (int)(y = (this.page == 0 && l == 0 ? (float)first : 0.0f) + (float)h * 12.0f), 10, 10) && !this.hoverMob(mouseX, mouseY, GuiLog.activeQuest.entitys.get(k))) {
                                this.setHoverText(new TextComponentTranslation("quest.hover.err.log.entity", new Object[0]).func_150254_d(), new Object[0]);
                            }
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179141_d();
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)0.0f);
                            GlStateManager.func_179152_a((float)0.3f, (float)0.15f, (float)1.0f);
                            GlStateManager.func_179131_c((float)3.0f, (float)3.0f, (float)3.0f, (float)1.0f);
                            this.field_146297_k.func_110434_K().func_110577_a(killIcon);
                            this.func_73729_b(0, 0, 32, 64, 32, 64);
                            GlStateManager.func_179121_F();
                        }
                        line = line.replace("\ufffe", " ");
                        ++k;
                    }
                    this.field_146289_q.func_175065_a(line, (l == 1 ? 105.0f : 0.0f) * scaleW, (float)((this.page == 0 && l == 0 ? first : 0) + h * 12), CustomNpcs.QuestLogColor.getRGB(), false);
                    ++h;
                }
                GlStateManager.func_179121_F();
            }
            if (this.page > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLLeft - 5.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLLeft - 5.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 5;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 5 ? 26 : 3, 207, 18, 10);
                GlStateManager.func_179121_F();
            }
            if (this.page * 2 < GuiLog.activeQuest.map.size()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLeft + 230.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLeft + 230.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 4;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 4 ? 26 : 3, 194, 18, 10);
                GlStateManager.func_179121_F();
            }
        } else if (this.quests.containsKey(selectCat)) {
            if (this.page > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLLeft - 5.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLLeft - 5.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 5;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 5 ? 26 : 3, 207, 18, 10);
                GlStateManager.func_179121_F();
            }
            if (Math.floor((double)this.quests.size() / 10.0) > (double)this.page) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.guiLeft + 230.0f * scaleW), (float)((float)this.guiLTop + 160.0f * scaleH), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, (int)((float)this.guiLeft + 230.0f * scaleW), (int)((float)this.guiLTop + 160.0f * scaleH), 18, 10)) {
                    this.hoverButton = 4;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hoverButton == 4 ? 26 : 3, 194, 18, 10);
                GlStateManager.func_179121_F();
            }
            i = 0;
            p = 0;
            Color color = this.categories.get(selectCat);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLLeft, (float)((float)this.guiLTop - 1.5f * scaleH), (float)0.0f);
            for (int id : this.quests.get(selectCat).keySet()) {
                boolean hasCancelableButton;
                boolean hasCompassButton;
                boolean hasExtraButton;
                if (p < this.page * 10) {
                    ++p;
                    continue;
                }
                if (i == 5) {
                    GlStateManager.func_179109_b((float)(105.0f * scaleW), (float)(-124.0f * scaleH), (float)0.0f);
                } else if (i % 5 != 0) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(31.0f * scaleH), (float)0.0f);
                }
                GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 98, 30);
                GlStateManager.func_179121_F();
                QuestData qd = this.quests.get(selectCat).get(id);
                Quest quest = qd.quest;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(3.0f * scaleW), (float)(3.0f * scaleH), (float)0.0f);
                this.field_146297_k.func_110434_K().func_110577_a(quest.icon);
                GlStateManager.func_179152_a((float)0.09375f, (float)0.09375f, (float)1.0f);
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 256, 256);
                GlStateManager.func_179121_F();
                int qxPos = (int)((float)this.guiLLeft + (float)(i > 4 ? 105 : 0) * scaleW);
                int qyPos = (int)((float)this.guiLTop + (-1.5f + (float)(i % 5) * 31.0f) * scaleH);
                boolean bl = hasExtraButton = quest.extraButton != 0 || this.player.field_71075_bZ.field_75098_d;
                if (hasExtraButton) {
                    int xo;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(87.0f * scaleW), (float)(19.0f * scaleH), (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    int n = xo = quest.extraButton == 0 ? 9 : quest.extraButton * 9;
                    if (quest.extraButton == 0 && this.player.field_71075_bZ.field_75098_d) {
                        this.func_73733_a(1, 1, 8, 8, 0x20FF0000, -2130771968);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        xo = (int)(System.currentTimeMillis() % 5000L / 1000L) * 9 + 9;
                    }
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    if (this.isMouseHover(mouseX, mouseY, qxPos + (int)(87.0f * scaleW), qyPos + (int)(19.0f * scaleH), (int)(9.0f * scaleW), (int)(9.0f * scaleH))) {
                        this.hoverButton = 30;
                        this.hoverQuestId = id;
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 0, 116 + xo, this.hoverButton == 30 && this.hoverQuestId == id ? 9 : 0, 9, 9);
                    GlStateManager.func_179121_F();
                }
                boolean bl2 = hasCompassButton = quest.hasCompassSettings() && (CustomNpcs.ShowQuestCompass || this.player.field_71075_bZ.field_75098_d);
                if (hasCompassButton) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((87.0f - (hasExtraButton ? 9.0f : 0.0f)) * scaleW), (float)(19.0f * scaleH), (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    if (!CustomNpcs.ShowQuestCompass && this.player.field_71075_bZ.field_75098_d) {
                        this.func_73733_a(1, 1, 8, 8, 0x20FF0000, -2130771968);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    if (this.isMouseHover(mouseX, mouseY, qxPos + (int)((87.0f - (hasExtraButton ? 9.0f : 0.0f)) * scaleW), qyPos + (int)(19.0f * scaleH), (int)(9.0f * scaleW), (int)(9.0f * scaleH))) {
                        this.hoverButton = 31;
                        this.hoverQuestId = id;
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 0, 107 + (this.playerData.hud.questID == quest.id ? 0 : 9), this.hoverButton == 31 && this.hoverQuestId == id ? 9 : 0, 9, 9);
                    GlStateManager.func_179121_F();
                }
                boolean bl3 = hasCancelableButton = quest.cancelable || this.player.field_71075_bZ.field_75098_d;
                if (hasCancelableButton) {
                    GlStateManager.func_179094_E();
                    float v = 87.0f - (hasExtraButton ? 9.0f : 0.0f) - (hasCompassButton ? 9.0f : 0.0f);
                    GlStateManager.func_179109_b((float)(v * scaleW), (float)(19.0f * scaleH), (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    if (!quest.cancelable && this.player.field_71075_bZ.field_75098_d) {
                        this.func_73733_a(1, 1, 8, 8, 0x20FF0000, -2130771968);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    if (this.isMouseHover(mouseX, mouseY, qxPos + (int)(v * scaleW), qyPos + (int)(19.0f * scaleH), (int)(9.0f * scaleW), (int)(9.0f * scaleH))) {
                        this.hoverButton = 32;
                        this.hoverQuestId = id;
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 0, 98, this.hoverButton == 32 && this.hoverQuestId == id ? 9 : 0, 9, 9);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(29.0f * scaleW), (float)(3.0f * scaleH), (float)0.0f);
                StringBuilder name = new StringBuilder();
                String qName = quest.getTitle();
                if ((float)this.field_146289_q.func_78256_a(qName) < 67.0f * scaleW) {
                    name = new StringBuilder(qName);
                } else {
                    for (int j = 0; j < qName.length(); ++j) {
                        if ((float)this.field_146289_q.func_78256_a(name.toString() + qName.charAt(j) + "...") >= 67.0f * scaleW) break;
                        name.append(qName.charAt(j));
                    }
                    name.append("...");
                }
                this.field_146289_q.func_175065_a(name.toString(), 0.0f, 0.0f, CustomNpcs.QuestLogColor.getRGB(), false);
                QuestObjective[] objs = quest.getObjectives((EntityPlayer)this.player);
                int j = 0;
                for (QuestObjective iqo : objs) {
                    if (!iqo.isCompleted()) continue;
                    ++j;
                }
                String progress = j + " / " + objs.length;
                this.field_146289_q.func_175065_a(progress, 0.0f, 10.0f, CustomNpcs.QuestLogColor.getRGB(), false);
                if (this.hoverButton > 29 && this.hoverQuestId == id) {
                    if (this.hoverButton == 30) {
                        hover.add(new TextComponentTranslation(quest.extraButtonText.isEmpty() ? "quest.hover.extra.button" : quest.extraButtonText, new Object[0]).func_150254_d());
                        if (quest.extraButton == 0 && this.player.field_71075_bZ.field_75098_d) {
                            hover.add(new TextComponentTranslation("quest.hover.gm.info", new Object[0]).func_150254_d());
                        }
                    } else if (this.hoverButton == 31) {
                        hover.add(new TextComponentTranslation("quest.hover.compass." + (this.playerData.hud.questID == quest.id), new Object[0]).func_150254_d());
                        if (!CustomNpcs.ShowQuestCompass && this.player.field_71075_bZ.field_75098_d) {
                            hover.add(new TextComponentTranslation("quest.hover.gm.info", new Object[0]).func_150254_d());
                        }
                    } else if (this.hoverButton == 32) {
                        hover.add(new TextComponentTranslation("drop.quest", new Object[]{quest.getName()}).func_150254_d());
                        if (!quest.cancelable && this.player.field_71075_bZ.field_75098_d) {
                            hover.add(new TextComponentTranslation("quest.hover.gm.info", new Object[0]).func_150254_d());
                        }
                    }
                } else if (this.isMouseHover(mouseX, mouseY, qxPos, qyPos, (int)(98.0f * scaleW), (int)(30.0f * scaleH))) {
                    this.hoverButton = 6;
                    this.hoverQuestId = id;
                    hover.add("\u00a77" + new TextComponentTranslation("drop.category", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + selectCat);
                    hover.add("\u00a77" + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + qName);
                    hover.add("\u00a77" + new TextComponentTranslation("gui.progress", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + (j >= objs.length ? "a" : "c") + progress);
                    if (quest.completion == EnumQuestCompletion.Npc && quest.completer != null) {
                        hover.add(new TextComponentTranslation("quest.completewith", new Object[]{quest.completer.func_70005_c_()}).func_150254_d());
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                ++p;
                if (++i != 10) continue;
                break;
            }
            GlStateManager.func_179121_F();
            if (!hover.isEmpty()) {
                this.setHoverText(hover);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.playerData = CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player);
        GlStateManager.func_179094_E();
        this.func_73733_a(0, 0, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, -1442840576, -1442840576);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tick >= 0) {
            float part;
            float cos;
            if (this.tick == 0) {
                partialTicks = 0.0f;
            }
            if ((cos = (float)Math.cos(90.0 * (double)(part = (float)this.tick + partialTicks) / (double)this.milliTick * Math.PI / 180.0)) < 0.0f) {
                cos = 0.0f;
            } else if (cos > 1.0f) {
                cos = 1.0f;
            }
            switch (this.step) {
                case 0: {
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(2));
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiCenter + (1.0f - cos) * ((float)this.guiCenter + 50.0f)), (float)((float)this.guiTopLog + (1.0f - cos) * 250.0f), (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.func_73729_b(0, 0, 0, 0, 128, 175);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 1;
                    this.tick = 21;
                    this.milliTick = 20;
                    MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.down", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    GlStateManager.func_179084_k();
                    break;
                }
                case 1: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiCenter, (float)this.guiTopLog, (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                    this.func_73729_b(0, 0, 128, 0, 128, 175);
                    GlStateManager.func_179121_F();
                    boolean up = this.tick >= this.milliTick / 2;
                    GlStateManager.func_179094_E();
                    if (up) {
                        part = (float)(this.tick - this.milliTick / 2) + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)this.guiCenter, (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)(1.0f - cos), (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(2));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    } else {
                        part = (float)this.tick + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)((float)this.guiCenter - cos * (float)this.field_146294_l / 2.0f), (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)cos, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    }
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 2;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 2: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTopLog, (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                    this.func_73729_b(0, 0, 0, 0, 256, 175);
                    if (this.temp > 0) {
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(1));
                        this.func_73729_b(0, 0, 0, 0, 256, 175);
                    }
                    GlStateManager.func_179121_F();
                    boolean up = this.tick >= this.milliTick / 2;
                    GlStateManager.func_179094_E();
                    if (up) {
                        part = (float)(this.tick - this.milliTick / 2) + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)this.guiCenter, (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)(1.0f - cos), (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 128, 0, 128, 175);
                    } else {
                        part = (float)this.tick + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)((float)this.guiCenter - cos * (float)this.field_146294_l / 2.0f), (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)cos, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    }
                    GlStateManager.func_179121_F();
                    if (this.tick == this.milliTick) {
                        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.sheet", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.8f + 0.4f * this.rnd.nextFloat());
                    }
                    if (this.tick != 0) break;
                    if (this.temp < 3) {
                        ++this.temp;
                        this.step = 2;
                        this.tick = 11;
                        this.milliTick = 10;
                    } else {
                        this.temp = 0;
                        this.step = 3;
                        this.tick = 21;
                        this.milliTick = 20;
                    }
                    GlStateManager.func_179084_k();
                    break;
                }
                case 3: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(this.guiLeft + 10), (float)((float)this.guiTop + (1.0f - cos) * 28.0f), (float)0.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)0.0f);
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)0.0f);
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    if (CustomNpcs.ShowQuestCompass) {
                        GlStateManager.func_179109_b((float)(-114.0f + 256.0f * scaleW), (float)0.0f, (float)0.0f);
                        this.func_73729_b(0, 0, 0, 30, 28, 30);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTopLog, (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                    this.func_73729_b(0, 0, 0, 0, 256, 175);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(1));
                    this.func_73729_b(0, 0, 0, 0, 256, 175);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = this.type + 4;
                    this.tick = 21;
                    this.milliTick = 20;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 4: {
                    this.drawBox(mouseX, mouseY);
                    if (!this.categories.isEmpty()) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)this.guiLeft, (float)((float)this.guiTopLog + 23.5f * scaleH), (float)0.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                        int i = 0;
                        int p = 0;
                        for (String catName : this.categories.keySet()) {
                            int catW = (int)((float)(this.field_146289_q.func_78256_a(catName) + 10 + i) * cos);
                            this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                            if (this.isMouseHover(mouseX, mouseY, this.guiLeft + (int)((float)(5 - catW) * scaleW), (int)((float)this.guiTopLog + (23.5f + (float)i * 16.0f) * scaleH), (int)((float)catW * scaleH), (int)(16.0f * scaleH))) {
                                this.hoverButton = 7 + i;
                            }
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                            this.func_73729_b(4 - (int)((float)catW / scaleW) + i, i * 16, 0, 90 + (this.catSelect == p || this.hoverButton == 7 + i ? 0 : 16), (int)((float)catW / scaleW), 16);
                            GlStateManager.func_179121_F();
                            StringBuilder name = new StringBuilder();
                            for (int j = 0; j < catName.length() && this.field_146289_q.func_78256_a(name.toString() + catName.charAt(j)) <= catW - 5; ++j) {
                                name.append(catName.charAt(j));
                            }
                            this.field_146289_q.func_175065_a(name.toString(), (float)(4 - catW + 10 + i), (16.0f * scaleH - 10.0f) / 2.0f + (float)(i * 16) * scaleH, CustomNpcs.QuestLogColor.getRGB(), false);
                            ++p;
                            if (++i < 8) continue;
                            break;
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179121_F();
                    } else {
                        this.tick = 0;
                    }
                    if (this.tick != 0) break;
                    this.step = this.toPrePage ? 10 : 11;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 5: {
                    this.drawBox(mouseX, mouseY);
                    if (this.tick != 0) break;
                    this.step = this.toPrePage ? 10 : 11;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 6: {
                    this.drawBox(mouseX, mouseY);
                    if (this.tick != 0) break;
                    this.step = this.toPrePage ? 10 : 11;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 7: {
                    this.drawBox(mouseX, mouseY);
                    if (!this.categories.isEmpty()) {
                        this.temp = 1;
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)this.guiLeft, (float)((float)this.guiTopLog + 7.5f), (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)16.0f, (float)0.0f);
                        int i = 0;
                        int p = 0;
                        int st = this.catRow * 8;
                        for (String catName : this.categories.keySet()) {
                            if (p < st) {
                                ++p;
                                continue;
                            }
                            int catW = (int)((float)(this.field_146289_q.func_78256_a(catName) + 10) * (1.0f - cos));
                            this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                            this.func_73729_b(5 - catW, i * 16, 0, 90 + (this.catSelect == p ? 0 : 16), catW, 16);
                            StringBuilder name = new StringBuilder();
                            for (int j = 0; j < catName.length() && this.field_146289_q.func_78256_a(name.toString() + catName.charAt(j)) <= catW - 5; ++j) {
                                name.append(catName.charAt(j));
                            }
                            this.field_146289_q.func_175065_a(name.toString(), (float)(10 - catW), (float)(3 + i * 16), CustomNpcs.QuestLogColor.getRGB(), false);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            if (++i < 8) continue;
                            break;
                        }
                        GlStateManager.func_179121_F();
                    } else {
                        this.tick = 0;
                        this.temp = 0;
                    }
                    if (this.tick != 0) break;
                    GlStateManager.func_179084_k();
                    this.step = this.type < 0 ? 12 : this.type + 4;
                    this.tick = 21;
                    this.milliTick = 20;
                    break;
                }
                case 8: {
                    this.drawBox(mouseX, mouseY);
                    if (this.tick != 0) break;
                    GlStateManager.func_179084_k();
                    this.step = this.type < 0 ? 12 : this.type + 4;
                    this.tick = 21;
                    this.milliTick = 20;
                    break;
                }
                case 9: {
                    this.drawBox(mouseX, mouseY);
                    if (this.tick != 0) break;
                    GlStateManager.func_179084_k();
                    this.step = this.type < 0 ? 12 : this.type + 4;
                    this.tick = 21;
                    this.milliTick = 20;
                    break;
                }
                case 10: {
                    this.drawBox(mouseX, mouseY);
                    boolean up = this.tick >= this.milliTick / 2;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (up) {
                        part = (float)(this.tick - this.milliTick / 2) + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)this.guiCenter, (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)(1.0f - cos), (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 128, 0, 128, 175);
                    } else {
                        part = (float)this.tick + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)((float)this.guiCenter - cos * (float)this.field_146294_l / 2.0f), (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)cos, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    }
                    GlStateManager.func_179121_F();
                    if (this.tick == this.milliTick) {
                        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.sheet", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.8f + 0.4f * this.rnd.nextFloat());
                    }
                    if (this.tick != 0) break;
                    this.step = -1;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 11: {
                    this.drawBox(mouseX, mouseY);
                    boolean up = this.tick >= this.milliTick / 2;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (up) {
                        part = (float)(this.tick - this.milliTick / 2) + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)((float)this.guiCenter - (1.0f - cos) * (float)this.field_146294_l / 2.0f), (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)(1.0f - cos), (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    } else {
                        part = (float)this.tick + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179109_b((float)this.guiCenter, (float)this.guiTopLog, (float)0.0f);
                        GlStateManager.func_179152_a((float)cos, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(3));
                        this.func_73729_b(0, 0, 128, 0, 128, 175);
                    }
                    GlStateManager.func_179121_F();
                    if (this.tick == this.milliTick) {
                        MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.sheet", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.8f + 0.4f * this.rnd.nextFloat());
                    }
                    if (this.tick != 0) break;
                    this.step = -1;
                    this.tick = 11;
                    this.milliTick = 10;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 12: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(this.guiLeft + 10), (float)((float)this.guiTop + cos * 28.0f), (float)0.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(4));
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)0.0f);
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    GlStateManager.func_179109_b((float)33.0f, (float)0.0f, (float)0.0f);
                    this.func_73729_b(0, 0, 0, 30, 28, 30);
                    if (CustomNpcs.ShowQuestCompass) {
                        GlStateManager.func_179109_b((float)(-114.0f + 256.0f * scaleW), (float)0.0f, (float)0.0f);
                        this.func_73729_b(0, 0, 0, 30, 28, 30);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTopLog, (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                    this.func_73729_b(0, 0, 0, 0, 256, 175);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(1));
                    this.func_73729_b(0, 0, 0, 0, 256, 175);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 13;
                    this.tick = 21;
                    this.milliTick = 20;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 13: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiCenter - 64.0f * cos), (float)this.guiTopLog, (float)0.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.func_73729_b(0, 0, 128, 0, 128, 175);
                    GlStateManager.func_179121_F();
                    boolean up = this.tick >= this.milliTick / 2;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiCenter - 64.0f * cos), (float)this.guiTopLog, (float)0.0f);
                    if (up) {
                        part = (float)(this.tick - this.milliTick / 2) + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179137_b((double)(-128.0 * (1.0 - (double)cos)), (double)0.0, (double)0.0);
                        GlStateManager.func_179152_a((float)(1.0f - cos), (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(0));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                        if (this.temp > 0) {
                            this.field_146297_k.func_110434_K().func_110577_a(ql.get(1));
                            this.func_73729_b(0, 0, 0, 0, 128, 175);
                        }
                    } else {
                        part = (float)this.tick + partialTicks;
                        cos = (float)Math.cos(90.0 * (double)part / ((double)this.milliTick / 2.0) * Math.PI / 180.0);
                        if (cos < 0.0f) {
                            cos = 0.0f;
                        } else if (cos > 1.0f) {
                            cos = 1.0f;
                        }
                        GlStateManager.func_179152_a((float)cos, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                        this.field_146297_k.func_110434_K().func_110577_a(ql.get(2));
                        this.func_73729_b(0, 0, 0, 0, 128, 175);
                    }
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:book.down", (float)this.player.field_70165_t, (float)this.player.field_70163_u, (float)this.player.field_70161_v, 1.0f, 0.75f + 0.25f * this.rnd.nextFloat());
                    this.step = 14;
                    this.tick = 21;
                    this.milliTick = 20;
                    GlStateManager.func_179084_k();
                    break;
                }
                case 14: {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)this.guiCenter - 64.0f + cos * ((float)this.guiCenter + 50.0f)), (float)((float)this.guiTopLog + cos * 250.0f), (float)0.0f);
                    GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(ql.get(2));
                    this.func_73729_b(0, 0, 0, 0, 128, 175);
                    GlStateManager.func_179121_F();
                    if (this.tick != 0) break;
                    this.step = 14;
                    this.tick = 101;
                    this.milliTick = 100;
                    this.save();
                    if (this.type == -1) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.player));
                    } else {
                        this.displayGuiScreen(null);
                        this.field_146297_k.func_71381_h();
                    }
                    GlStateManager.func_179084_k();
                }
            }
            --this.tick;
            if (this.step != -1) {
                GlStateManager.func_179121_F();
                return;
            }
        }
        this.drawBox(mouseX, mouseY);
        GlStateManager.func_179121_F();
        if (this.tick < 0 && this.step == -1) {
            GlStateManager.func_179094_E();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            GlStateManager.func_179121_F();
        }
        if (this.type == 2) {
            if (this.getTextField(0) != null && this.getTextField(0).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.upos", new Object[0]);
            } else if (this.getTextField(1) != null && this.getTextField(1).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.vpos", new Object[0]);
            } else if (this.getButton(0) != null && this.getButton(0).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.showname", new Object[0]);
            } else if (this.getButton(1) != null && this.getButton(1).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.showtask", new Object[0]);
            } else if (this.getSlider(0) != null && this.getSlider(0).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.scale", new Object[0]);
            } else if (this.getSlider(1) != null && this.getSlider(1).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.incline", new Object[0]);
            } else if (this.getSlider(2) != null && this.getSlider(2).isHovered()) {
                this.setHoverText("quest.hover.compass.edit.rotation", new Object[0]);
            }
        }
        this.drawHoverText(null, new Object[0]);
    }

    protected boolean hoverMob(int mouseX, int mouseY, Entity entity) {
        if (entity == null) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((this.guiLeft + 22) * -1), (double)(this.guiTopLog * -1), (double)300.0);
        GlStateManager.func_179109_b((float)mouseX, (float)mouseY, (float)0.0f);
        if ((double)mouseY > this.sw.func_78324_d() / 2.0) {
            GlStateManager.func_179109_b((float)0.0f, (float)-15.0f, (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)45.0f, (float)0.0f);
        }
        String modelName = "";
        if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).display.getModel() != null) {
            modelName = ((EntityNPCInterface)entity).display.getModel();
        } else {
            ResourceLocation location = EntityList.func_191301_a((Entity)entity);
            if (location != null) {
                modelName = location.toString();
            }
        }
        boolean canUpdate = GuiLog.preDrawEntity(modelName);
        GlStateManager.func_179114_b((float)((float)(this.field_146297_k.field_71441_e.func_82737_E() % 360L) * 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        GlStateManager.func_179152_a((float)25.0f, (float)25.0f, (float)25.0f);
        entity.field_70173_aa = 1;
        if (canUpdate) {
            entity.func_70071_h_();
        }
        this.field_146297_k.func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179121_F();
        return true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.sw = new ScaledResolution(this.field_146297_k);
        scaleW = ((float)this.sw.func_78327_c() - 160.0f) / 256.0f;
        scaleH = ((float)this.sw.func_78324_d() - 78.0f) / 175.0f;
        this.guiCenter = (int)Math.ceil(this.sw.func_78327_c() / 2.0 + 15.0 * (double)scaleW);
        this.field_146294_l = (int)(256.0f * scaleW);
        this.field_146295_m = (int)(203.0f * scaleH);
        this.guiLeft = this.guiCenter - (int)(128.0f * scaleW);
        this.guiTop = 25;
        this.guiTopLog = this.guiTop + 28;
        this.guiLLeft = this.guiLeft + (int)(26.0f * scaleW);
        this.guiLRight = this.guiCenter + (int)(2.0f * scaleW);
        this.guiLTop = this.guiTopLog + (int)(8.0f * scaleH);
        if (this.type == 0) {
            this.quests.clear();
            this.categories.clear();
            Collection<QuestData> list = CustomNpcs.proxy.getPlayerData((EntityPlayer)this.player).questData.activeQuests.values();
            if (!list.isEmpty()) {
                for (QuestData qd : list) {
                    Quest quest = qd.quest;
                    String catName = quest.category.getName();
                    if (!this.categories.containsKey(catName)) {
                        int r = 128;
                        int g = 32;
                        int b = 224;
                        block6: for (int i = 0; i < catName.length(); ++i) {
                            switch (i % 3) {
                                case 0: {
                                    r += catName.charAt(i);
                                    continue block6;
                                }
                                case 1: {
                                    g += catName.charAt(i);
                                    continue block6;
                                }
                                case 2: {
                                    b += catName.charAt(i);
                                }
                            }
                        }
                        this.categories.put(catName, new Color(r * catName.length() % 256, g * catName.length() % 256, b * catName.length() % 256));
                    }
                    if (!this.quests.containsKey(catName)) {
                        this.quests.put(catName, new TreeMap());
                    }
                    this.quests.get(catName).put(quest.id, qd);
                }
            }
            if (activeQuest != null) {
                activeQuest.reset();
            }
            while (this.catSelect >= this.categories.size()) {
                --this.catSelect;
            }
        } else if (this.type == 2) {
            int x0 = this.guiLLeft + 8;
            int x1 = this.guiLRight + (int)(3.0f * scaleW);
            int y = (int)((float)this.guiLTop + 82.0f * scaleH);
            this.addTextField(new GuiNpcTextField(0, this, this.field_146289_q, x0, y, (int)(40.0f * scaleW), (int)(10.0f * scaleH), "" + this.compassData.screenPos[0]));
            this.getTextField(0).setMinMaxDoubleDefault(0.0, 1.0, this.compassData.screenPos[0]);
            this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, x0 + (int)(54.0f * scaleW), y, (int)(40.0f * scaleW), (int)(10.0f * scaleH), "" + this.compassData.screenPos[1]));
            this.getTextField(1).setMinMaxDoubleDefault(0.0, 1.0, this.compassData.screenPos[1]);
            float v = this.compassData.scale - 0.5f;
            this.addSlider(new GuiNpcSlider(this, 0, --x0, y += (int)(17.0f * scaleH), (int)(96.0f * scaleW), (int)(12.0f * scaleH), v));
            this.getSlider(0).setString(("" + this.compassData.scale).replace(".", ","));
            v = this.compassData.incline * -0.022222f + 0.5f;
            this.addSlider(new GuiNpcSlider(this, 1, x0, y += (int)(16.0f * scaleH), (int)(96.0f * scaleW), (int)(12.0f * scaleH), v));
            this.getSlider(1).setString(("" + (45.0f + this.compassData.incline * -1.0f)).replace(".", ","));
            this.addButton(new GuiNpcCheckBox(0, x1, y - (int)scaleH, (int)(100.0f * scaleW), (int)(12.0f * scaleH), "quest.screen.show.quest", null, this.compassData.showQuestName));
            this.getButton(0).setTextColor(CustomNpcs.QuestLogColor.getRGB());
            v = this.compassData.rot * 0.016667f + 0.5f;
            this.addSlider(new GuiNpcSlider(this, 2, x0, y += (int)(16.0f * scaleH), (int)(96.0f * scaleW), (int)(12.0f * scaleH), v));
            this.getSlider(2).setString(("" + this.compassData.rot).replace(".", ","));
            this.addButton(new GuiNpcCheckBox(1, x1, y - (int)scaleH, (int)(100.0f * scaleW), (int)(12.0f * scaleH), "quest.screen.show.task", null, this.compassData.showTaskProgress));
            this.getButton(1).setTextColor(CustomNpcs.QuestLogColor.getRGB());
            this.addButton(new GuiNpcCheckBox(2, x1, (y += (int)(16.0f * scaleH)) - (int)scaleH, (int)(100.0f * scaleW), (int)(12.0f * scaleH), "quest.screen.show.compass", null, CustomNpcs.ShowQuestCompass));
            this.getButton(2).setTextColor(CustomNpcs.QuestLogColor.getRGB());
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.step >= 0) {
            return;
        }
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.tick = 15;
            this.milliTick = 15;
            this.step = this.type + 7;
            this.type = i == 1 ? -2 : -1;
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        mouseX = this.mouseX;
        mouseY = this.mouseY;
        if (this.step >= 0) {
            return;
        }
        if (this.type == 2) {
            super.func_73864_a(mouseX, mouseY, mouseBottom);
            if (mouseX >= (int)((float)this.guiLLeft - 3.0f * scaleW) && mouseX <= (int)((float)this.guiLLeft + 100.0f * scaleW) && mouseY >= this.guiLTop + 10 && mouseY <= (int)((float)(this.guiLTop + 10) + 69.0f * scaleH)) {
                double x = (float)(mouseX - (int)((float)this.guiLLeft - 3.0f * scaleW)) / scaleW;
                double y = (float)(mouseY - (this.guiLTop + 10)) / scaleH;
                this.compassData.screenPos[0] = (double)Math.round(x / 103.0 * 1000.0) / 1000.0;
                this.compassData.screenPos[1] = (double)Math.round(y / 69.0 * 1000.0) / 1000.0;
                this.func_73866_w_();
            }
        }
        this.buttonPress(this.hoverButton);
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        if (this.type != 2) {
            return;
        }
        switch (slider.getID()) {
            case 0: {
                this.compassData.scale = (float)Math.round((slider.getSliderValue() + 0.5f) * 100.0f) / 100.0f;
                slider.setString(("" + this.compassData.scale).replace(".", ","));
                break;
            }
            case 1: {
                this.compassData.incline = (float)Math.round((-45.0f * slider.getSliderValue() + 22.5f) * 100.0f) / 100.0f;
                slider.setString(("" + (45.0f + this.compassData.incline * -1.0f)).replace(".", ","));
                break;
            }
            case 2: {
                this.compassData.rot = (float)Math.round((60.0f * slider.getSliderValue() - 30.0f) * 100.0f) / 100.0f;
                slider.setString(("" + this.compassData.rot).replace(".", ","));
            }
        }
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void save() {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.SaveCompassData, this.compassData.getNbt());
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_150297_b("FactionList", 9)) {
            this.playerFactions.clear();
            NBTTagList list = compound.func_150295_c("FactionList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Faction faction = new Faction();
                faction.load(list.func_150305_b(i));
                this.playerFactions.add(faction);
            }
            PlayerFactionData data = new PlayerFactionData();
            data.loadNBTData(compound);
            for (int id : data.factionData.keySet()) {
                int points = data.factionData.get(id);
                for (Faction faction2 : this.playerFactions) {
                    if (faction2.id != id) continue;
                    faction2.defaultPoints = points;
                }
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.type != 2) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                this.compassData.screenPos[0] = (double)Math.round(textField.getDouble() * 100.0) / 100.0;
                break;
            }
            case 1: {
                this.compassData.screenPos[1] = (double)Math.round(textField.getDouble() * 100.0) / 100.0;
            }
        }
    }

    static {
        ql.clear();
        for (int i = 0; i < 6; ++i) {
            ql.put(i, new ResourceLocation("customnpcs", "textures/quest log/q_log_" + i + ".png"));
        }
    }

    public static class QuestInfo {
        public final QuestData qData;
        protected EntityNPCInterface npc;
        protected final Map<Integer, List<String>> map = new TreeMap<Integer, List<String>>();
        public final List<ItemStack> stacks = new ArrayList<ItemStack>();
        public final Map<Integer, Entity> entitys = new TreeMap<Integer, Entity>();
        protected final World world;
        protected boolean newInstance = true;

        public QuestInfo(QuestData qd, World world) {
            this.world = world;
            this.qData = qd;
            if (qd.quest.completer != null) {
                NBTTagCompound compound = new NBTTagCompound();
                qd.quest.completer.func_70039_c(compound);
                compound.func_186854_a("UUID", UUID.randomUUID());
                Entity e = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
                if (e instanceof EntityNPCInterface) {
                    this.npc = (EntityNPCInterface)e;
                } else {
                    this.npc = (EntityNPCInterface)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("customnpcs", "customnpc"), (World)world);
                    if (this.npc != null) {
                        this.npc.func_70037_a(compound);
                    }
                }
            } else {
                qd.quest.completer = this.npc = (EntityNPCInterface)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("customnpcs", "customnpc"), (World)world);
                if (this.npc != null) {
                    qd.quest.completerPos[0] = (int)this.npc.field_70165_t;
                    qd.quest.completerPos[1] = (int)(this.npc.field_70163_u + 0.5);
                    qd.quest.completerPos[2] = (int)this.npc.field_70161_v;
                    qd.quest.completerPos[3] = this.npc.field_70170_p.field_73011_w.getDimension();
                }
            }
            this.npc = Util.instance.copyToGUI(this.npc, world, false);
        }

        public Map<Integer, List<String>> getText(int first, EntityPlayer player, FontRenderer fontRenderer) {
            QuestObjective[] allObj;
            if (!this.newInstance && !this.map.isEmpty()) {
                return this.map;
            }
            this.map.clear();
            this.stacks.clear();
            this.entitys.clear();
            String ent = "\n";
            StringBuilder text = new StringBuilder("\u00a7l" + new TextComponentTranslation(this.qData.quest.title, new Object[0]).func_150254_d() + ent);
            if (this.qData.quest.completion == EnumQuestCompletion.Npc && this.qData.quest.completer != null) {
                text.append(new TextComponentTranslation("quest.completeness", new Object[]{"\u00a7l" + this.qData.quest.completer.func_70005_c_()}).func_150254_d()).append(ent);
            }
            if ((allObj = this.qData.quest.getObjectives(player)).length > 0) {
                text.append(ent).append('\u00a7').append("l").append(new TextComponentTranslation("quest.objectives." + this.qData.quest.step, new Object[0]).func_150254_d()).append(ent);
                for (int i = 0; i < allObj.length; ++i) {
                    text.append(i + 1).append("-");
                    if (allObj[i].getEnumType() == EnumQuestTask.ITEM || allObj[i].getEnumType() == EnumQuestTask.CRAFT) {
                        this.stacks.add(allObj[i].getItemStack());
                        text.append(" \uffff ");
                    } else if (allObj[i].getEnumType() == EnumQuestTask.KILL || allObj[i].getEnumType() == EnumQuestTask.AREAKILL) {
                        text.append(" \ufffe ");
                        if (allObj[i].isNotShowLogEntity()) {
                            this.entitys.put(this.entitys.size(), null);
                        } else {
                            IPos pos;
                            String target = allObj[i].getTargetName();
                            Object e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(target), (World)this.world);
                            if (e == null && (pos = allObj[i].getCompassPos()).getY() >= 0.0 && (pos.getX() != 0.0 || pos.getZ() != 0.0) && this.world.field_73011_w.getDimension() == allObj[i].getCompassDimension()) {
                                int r = allObj[i].getCompassRange();
                                List list = new ArrayList();
                                try {
                                    list = this.world.func_72872_a(Entity.class, new AxisAlignedBB(pos.getX() - (double)r, pos.getY() - (double)r, pos.getZ() - (double)r, pos.getX() + (double)r, pos.getY() + (double)r, pos.getZ() + (double)r));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                for (Entity en : list) {
                                    if (!en.func_70005_c_().equals(target)) continue;
                                    NBTTagCompound compound = new NBTTagCompound();
                                    en.func_184198_c(compound);
                                    Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)this.world);
                                    if (entity == null) {
                                        e = en;
                                        break;
                                    }
                                    e = entity;
                                    if (!(e instanceof EntityNPCInterface)) break;
                                    e = Util.instance.copyToGUI((EntityNPCInterface)((Object)e), this.world, false);
                                    break;
                                }
                            }
                            this.entitys.put(this.entitys.size(), (Entity)e);
                        }
                    }
                    text.append(allObj[i].getText()).append(ent);
                }
                text = new StringBuilder(text.substring(0, text.length() - 1));
            }
            text.append(this.qData.quest.getLogText());
            ArrayList<String> lines = new ArrayList<String>();
            int currentList = 0;
            String line = "";
            text = new StringBuilder(text.toString().replace("\n", " \n "));
            text = new StringBuilder(text.toString().replace("\r", " \r "));
            String[] words = text.toString().split(" ");
            String color = "\u00a7r";
            float width = 98.0f * scaleW;
            for (String word : words) {
                char c;
                if (word.isEmpty()) continue;
                if (word.length() == 1 && ((c = word.charAt(0)) == '\r' || c == '\n')) {
                    lines.add(color + line);
                    color = Util.instance.getLastColor(color, line);
                    line = "";
                    continue;
                }
                String newLine = line.isEmpty() ? word : line + " " + word;
                if ((float)fontRenderer.func_78256_a(newLine) > width) {
                    lines.add(color + line);
                    color = Util.instance.getLastColor(color, line);
                    line = word.trim();
                    continue;
                }
                line = newLine;
            }
            if (!line.isEmpty()) {
                lines.add(color + line);
            }
            ArrayList<String> list = new ArrayList<String>();
            float height = (3.57143f * scaleH + 116.42857f) * scaleH;
            for (String l : lines) {
                float f = list.size() * 10;
                int n = currentList == 0 ? first : 0;
                if (f > height - (float)n) {
                    this.map.put(currentList, list);
                    list = new ArrayList();
                    ++currentList;
                }
                list.add(l);
            }
            if (!list.isEmpty()) {
                this.map.put(currentList, list);
            }
            this.newInstance = false;
            ArrayList<ItemStack> rewarList = new ArrayList<ItemStack>();
            for (int i = 0; i < this.qData.quest.rewardItems.func_70302_i_(); ++i) {
                ItemStack stack = this.qData.quest.rewardItems.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                boolean has = false;
                if (this.qData.quest.rewardType == EnumRewardType.ALL) {
                    for (ItemStack it : rewarList) {
                        if (!stack.func_77969_a(it) || !ItemStack.areItemStackShareTagsEqual((ItemStack)stack, (ItemStack)it)) continue;
                        has = true;
                        break;
                    }
                }
                if (has) continue;
                rewarList.add(stack);
            }
            if (!rewarList.isEmpty()) {
                this.stacks.addAll(rewarList);
            }
            return this.map;
        }

        public void reset() {
            this.newInstance = true;
        }
    }
}

